package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CryingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😢",
        description = "crying face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("crying-face", "cry"),
        emoticons = listOf(":'("),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: crying face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CryingFace: Emoji get() = _CryingFace

/**
 * Alias to emoji [CryingFace] (Smileys & Emotion: face-concerned: crying face).
*/
public val Emoji.Companion.Cry: Emoji get() = _CryingFace
