package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DisappointedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😞",
        description = "disappointed face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("disappointed-face", "sad"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: disappointed face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DisappointedFace: Emoji get() = _DisappointedFace

/**
 * Alias to emoji [DisappointedFace] (Smileys & Emotion: face-concerned: disappointed face).
*/
public val Emoji.Companion.Sad: Emoji get() = _DisappointedFace
