package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WorriedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😟",
        description = "worried face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("worried-face", "worried"),
        emoticons = listOf(":S"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: worried face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WorriedFace: Emoji get() = _WorriedFace

/**
 * Alias to emoji [WorriedFace] (Smileys & Emotion: face-concerned: worried face).
*/
public val Emoji.Companion.Worried: Emoji get() = _WorriedFace
