package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _YawningFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥱",
        description = "yawning face",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("yawning-face", "yawn"),
        emoticons = listOf("~O~"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: yawning face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.YawningFace: Emoji get() = _YawningFace

/**
 * Alias to emoji [YawningFace] (Smileys & Emotion: face-concerned: yawning face).
*/
public val Emoji.Companion.Yawn: Emoji get() = _YawningFace
