package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceConcerned() {
    add(intArrayOf(0x1f615), _ConfusedFace)
    add(intArrayOf(0x1fae4), _FaceWithDiagonalMouth)
    add(intArrayOf(0x1f61f), _WorriedFace)
    add(intArrayOf(0x1f641), _SlightlyFrowningFace)
    add(intArrayOf(0x2639, 0xfe0f), _FrowningFace)
    add(intArrayOf(0x2639), _FrowningFace)
    add(intArrayOf(0x1f62e), _FaceWithOpenMouth)
    add(intArrayOf(0x1f62f), _HushedFace)
    add(intArrayOf(0x1f632), _AstonishedFace)
    add(intArrayOf(0x1f633), _FlushedFace)
    add(intArrayOf(0x1f97a), _PleadingFace)
    add(intArrayOf(0x1f979), _FaceHoldingBackTears)
    add(intArrayOf(0x1f626), _FrowningFaceWithOpenMouth)
    add(intArrayOf(0x1f627), _AnguishedFace)
    add(intArrayOf(0x1f628), _FearfulFace)
    add(intArrayOf(0x1f630), _AnxiousFaceWithSweat)
    add(intArrayOf(0x1f625), _SadButRelievedFace)
    add(intArrayOf(0x1f622), _CryingFace)
    add(intArrayOf(0x1f62d), _LoudlyCryingFace)
    add(intArrayOf(0x1f631), _FaceScreamingInFear)
    add(intArrayOf(0x1f616), _ConfoundedFace)
    add(intArrayOf(0x1f623), _PerseveringFace)
    add(intArrayOf(0x1f61e), _DisappointedFace)
    add(intArrayOf(0x1f613), _DowncastFaceWithSweat)
    add(intArrayOf(0x1f629), _WearyFace)
    add(intArrayOf(0x1f62b), _TiredFace)
    add(intArrayOf(0x1f971), _YawningFace)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceConcerned() {
    yield(_ConfusedFace)
    yield(_FaceWithDiagonalMouth)
    yield(_WorriedFace)
    yield(_SlightlyFrowningFace)
    yield(_FrowningFace)
    yield(_FaceWithOpenMouth)
    yield(_HushedFace)
    yield(_AstonishedFace)
    yield(_FlushedFace)
    yield(_PleadingFace)
    yield(_FaceHoldingBackTears)
    yield(_FrowningFaceWithOpenMouth)
    yield(_AnguishedFace)
    yield(_FearfulFace)
    yield(_AnxiousFaceWithSweat)
    yield(_SadButRelievedFace)
    yield(_CryingFace)
    yield(_LoudlyCryingFace)
    yield(_FaceScreamingInFear)
    yield(_ConfoundedFace)
    yield(_PerseveringFace)
    yield(_DisappointedFace)
    yield(_DowncastFaceWithSweat)
    yield(_WearyFace)
    yield(_TiredFace)
    yield(_YawningFace)
}

internal val countFaceConcerned = 26

/**
 * All Emoji of the Smileys & Emotion: face-concerned subgroup.
*/
public fun Emoji.Companion.sequenceFaceConcerned(): Sequence<Emoji> =
    sequence { yieldAllFaceConcerned() }

/**
 * All Emoji of the Smileys & Emotion: face-concerned subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceConcerned(): List<Emoji> =
    ArrayList<Emoji>(countFaceConcerned).also { list -> sequenceFaceConcerned().forEach { list.add(it) } }

@Deprecated("Renamed listFaceConcerned.", replaceWith = ReplaceWith("listFaceConcerned()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceConcerned(): List<Emoji> =
    listFaceConcerned()
