package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShushingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤫",
        description = "shushing face",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("shushing-face", ),
        emoticons = listOf("(￣b￣)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: shushing face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShushingFace: Emoji get() = _ShushingFace
