package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceSmiling() {
    add(intArrayOf(0x1f600), _GrinningFace)
    add(intArrayOf(0x1f603), _GrinningFaceWithBigEyes)
    add(intArrayOf(0x1f604), _GrinningFaceWithSmilingEyes)
    add(intArrayOf(0x1f601), _BeamingFaceWithSmilingEyes)
    add(intArrayOf(0x1f606), _GrinningSquintingFace)
    add(intArrayOf(0x1f605), _GrinningFaceWithSweat)
    add(intArrayOf(0x1f923), _RollingOnTheFloorLaughing)
    add(intArrayOf(0x1f602), _FaceWithTearsOfJoy)
    add(intArrayOf(0x1f642), _SlightlySmilingFace)
    add(intArrayOf(0x1f643), _UpsideDownFace)
    add(intArrayOf(0x1fae0), _MeltingFace)
    add(intArrayOf(0x1f609), _WinkingFace)
    add(intArrayOf(0x1f60a), _SmilingFaceWithSmilingEyes)
    add(intArrayOf(0x1f607), _SmilingFaceWithHalo)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceSmiling() {
    yield(_GrinningFace)
    yield(_GrinningFaceWithBigEyes)
    yield(_GrinningFaceWithSmilingEyes)
    yield(_BeamingFaceWithSmilingEyes)
    yield(_GrinningSquintingFace)
    yield(_GrinningFaceWithSweat)
    yield(_RollingOnTheFloorLaughing)
    yield(_FaceWithTearsOfJoy)
    yield(_SlightlySmilingFace)
    yield(_UpsideDownFace)
    yield(_MeltingFace)
    yield(_WinkingFace)
    yield(_SmilingFaceWithSmilingEyes)
    yield(_SmilingFaceWithHalo)
}

internal val countFaceSmiling = 14

/**
 * All Emoji of the Smileys & Emotion: face-smiling subgroup.
*/
public fun Emoji.Companion.sequenceFaceSmiling(): Sequence<Emoji> =
    sequence { yieldAllFaceSmiling() }

/**
 * All Emoji of the Smileys & Emotion: face-smiling subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceSmiling(): List<Emoji> =
    ArrayList<Emoji>(countFaceSmiling).also { list -> sequenceFaceSmiling().forEach { list.add(it) } }

@Deprecated("Renamed listFaceSmiling.", replaceWith = ReplaceWith("listFaceSmiling()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceSmiling(): List<Emoji> =
    listFaceSmiling()
