package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithHeadBandage: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤕",
        description = "face with head-bandage",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-with-head-bandage", "bandage-face"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face with head-bandage.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithHeadBandage: Emoji get() = _FaceWithHeadBandage

/**
 * Alias to emoji [FaceWithHeadBandage] (Smileys & Emotion: face-unwell: face with head-bandage).
*/
public val Emoji.Companion.BandageFace: Emoji get() = _FaceWithHeadBandage
