package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithSpiralEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😵‍💫",
        description = "face with spiral eyes",
        unicodeVersion = UnicodeVersion(13, 1),
        aliases = listOf("face-with-spiral-eyes", "dizzy-face"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face with spiral eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithSpiralEyes: Emoji get() = _FaceWithSpiralEyes

/**
 * Alias to emoji [FaceWithSpiralEyes] (Smileys & Emotion: face-unwell: face with spiral eyes).
*/
public val Emoji.Companion.DizzyFace: Emoji get() = _FaceWithSpiralEyes
