package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceUnwell() {
    add(intArrayOf(0x1f637), _FaceWithMedicalMask)
    add(intArrayOf(0x1f912), _FaceWithThermometer)
    add(intArrayOf(0x1f915), _FaceWithHeadBandage)
    add(intArrayOf(0x1f922), _NauseatedFace)
    add(intArrayOf(0x1f92e), _FaceVomiting)
    add(intArrayOf(0x1f927), _SneezingFace)
    add(intArrayOf(0x1f975), _HotFace)
    add(intArrayOf(0x1f976), _ColdFace)
    add(intArrayOf(0x1f974), _WoozyFace)
    add(intArrayOf(0x1f635), _FaceWithCrossedOutEyes)
    add(intArrayOf(0x1f635, 0x200d, 0x1f4ab), _FaceWithSpiralEyes)
    add(intArrayOf(0x1f92f), _ExplodingHead)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceUnwell() {
    yield(_FaceWithMedicalMask)
    yield(_FaceWithThermometer)
    yield(_FaceWithHeadBandage)
    yield(_NauseatedFace)
    yield(_FaceVomiting)
    yield(_SneezingFace)
    yield(_HotFace)
    yield(_ColdFace)
    yield(_WoozyFace)
    yield(_FaceWithCrossedOutEyes)
    yield(_FaceWithSpiralEyes)
    yield(_ExplodingHead)
}

internal val countFaceUnwell = 12

/**
 * All Emoji of the Smileys & Emotion: face-unwell subgroup.
*/
public fun Emoji.Companion.sequenceFaceUnwell(): Sequence<Emoji> =
    sequence { yieldAllFaceUnwell() }

/**
 * All Emoji of the Smileys & Emotion: face-unwell subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceUnwell(): List<Emoji> =
    ArrayList<Emoji>(countFaceUnwell).also { list -> sequenceFaceUnwell().forEach { list.add(it) } }

@Deprecated("Renamed listFaceUnwell.", replaceWith = ReplaceWith("listFaceUnwell()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceUnwell(): List<Emoji> =
    listFaceUnwell()
