package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartDecoration: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💟",
        description = "heart decoration",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("heart-decoration", "heart-box"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: heart decoration.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartDecoration: Emoji get() = _HeartDecoration

/**
 * Alias to emoji [HeartDecoration] (Smileys & Emotion: heart: heart decoration).
*/
public val Emoji.Companion.HeartBox: Emoji get() = _HeartDecoration
