package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LoveLetter: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💌",
        description = "love letter",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("love-letter", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: love letter.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LoveLetter: Emoji get() = _LoveLetter
