package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _YellowHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💛",
        description = "yellow heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("yellow-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: yellow heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.YellowHeart: Emoji get() = _YellowHeart
