package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InputNumbers: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔢",
        description = "input numbers",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("input-numbers", "numbers"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: input numbers.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InputNumbers: Emoji get() = _InputNumbers

/**
 * Alias to emoji [InputNumbers] (Symbols: alphanum: input numbers).
*/
public val Emoji.Companion.Numbers: Emoji get() = _InputNumbers
