package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseCongratulationsButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "㊗️",
        description = "Japanese “congratulations” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-congratulations-button", "congratulations"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “congratulations” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseCongratulationsButton: Emoji get() = _JapaneseCongratulationsButton

/**
 * Alias to emoji [JapaneseCongratulationsButton] (Symbols: alphanum: Japanese “congratulations” button).
*/
public val Emoji.Companion.Congratulations: Emoji get() = _JapaneseCongratulationsButton
