package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NgButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆖",
        description = "NG button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ng-button", "ng"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: NG button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NgButton: Emoji get() = _NgButton

/**
 * Alias to emoji [NgButton] (Symbols: alphanum: NG button).
*/
public val Emoji.Companion.Ng: Emoji get() = _NgButton
