package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CounterclockwiseArrowsButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔄",
        description = "counterclockwise arrows button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("counterclockwise-arrows-button", "counterclockwise-arrows"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: counterclockwise arrows button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CounterclockwiseArrowsButton: Emoji get() = _CounterclockwiseArrowsButton

/**
 * Alias to emoji [CounterclockwiseArrowsButton] (Symbols: arrow: counterclockwise arrows button).
*/
public val Emoji.Companion.CounterclockwiseArrows: Emoji get() = _CounterclockwiseArrowsButton
