package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeftArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⬅️",
        description = "left arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("left-arrow", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: left arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftArrow: Emoji get() = _LeftArrow
