package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeftRightArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↔️",
        description = "left-right arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("left-right-arrow", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: left-right arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftRightArrow: Emoji get() = _LeftRightArrow
