package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _VibrationMode: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📳",
        description = "vibration mode",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("vibration-mode", "vibration"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: vibration mode.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VibrationMode: Emoji get() = _VibrationMode

/**
 * Alias to emoji [VibrationMode] (Symbols: av-symbol: vibration mode).
*/
public val Emoji.Companion.Vibration: Emoji get() = _VibrationMode
