package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAvSymbol() {
    add(intArrayOf(0x1f500), _ShuffleTracksButton)
    add(intArrayOf(0x1f501), _RepeatButton)
    add(intArrayOf(0x1f502), _RepeatSingleButton)
    add(intArrayOf(0x25b6, 0xfe0f), _PlayButton)
    add(intArrayOf(0x25b6), _PlayButton)
    add(intArrayOf(0x23e9), _FastForwardButton)
    add(intArrayOf(0x23ed, 0xfe0f), _NextTrackButton)
    add(intArrayOf(0x23ed), _NextTrackButton)
    add(intArrayOf(0x23ef, 0xfe0f), _PlayOrPauseButton)
    add(intArrayOf(0x23ef), _PlayOrPauseButton)
    add(intArrayOf(0x25c0, 0xfe0f), _ReverseButton)
    add(intArrayOf(0x25c0), _ReverseButton)
    add(intArrayOf(0x23ea), _FastReverseButton)
    add(intArrayOf(0x23ee, 0xfe0f), _LastTrackButton)
    add(intArrayOf(0x23ee), _LastTrackButton)
    add(intArrayOf(0x1f53c), _UpwardsButton)
    add(intArrayOf(0x23eb), _FastUpButton)
    add(intArrayOf(0x1f53d), _DownwardsButton)
    add(intArrayOf(0x23ec), _FastDownButton)
    add(intArrayOf(0x23f8, 0xfe0f), _PauseButton)
    add(intArrayOf(0x23f8), _PauseButton)
    add(intArrayOf(0x23f9, 0xfe0f), _StopButton)
    add(intArrayOf(0x23f9), _StopButton)
    add(intArrayOf(0x23fa, 0xfe0f), _RecordButton)
    add(intArrayOf(0x23fa), _RecordButton)
    add(intArrayOf(0x23cf, 0xfe0f), _EjectButton)
    add(intArrayOf(0x23cf), _EjectButton)
    add(intArrayOf(0x1f3a6), _Cinema)
    add(intArrayOf(0x1f505), _DimButton)
    add(intArrayOf(0x1f506), _BrightButton)
    add(intArrayOf(0x1f4f6), _AntennaBars)
    add(intArrayOf(0x1f6dc), _Wireless)
    add(intArrayOf(0x1f4f3), _VibrationMode)
    add(intArrayOf(0x1f4f4), _MobilePhoneOff)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAvSymbol() {
    yield(_ShuffleTracksButton)
    yield(_RepeatButton)
    yield(_RepeatSingleButton)
    yield(_PlayButton)
    yield(_FastForwardButton)
    yield(_NextTrackButton)
    yield(_PlayOrPauseButton)
    yield(_ReverseButton)
    yield(_FastReverseButton)
    yield(_LastTrackButton)
    yield(_UpwardsButton)
    yield(_FastUpButton)
    yield(_DownwardsButton)
    yield(_FastDownButton)
    yield(_PauseButton)
    yield(_StopButton)
    yield(_RecordButton)
    yield(_EjectButton)
    yield(_Cinema)
    yield(_DimButton)
    yield(_BrightButton)
    yield(_AntennaBars)
    yield(_Wireless)
    yield(_VibrationMode)
    yield(_MobilePhoneOff)
}

internal val countAvSymbol = 25

/**
 * All Emoji of the Symbols: av-symbol subgroup.
*/
public fun Emoji.Companion.sequenceAvSymbol(): Sequence<Emoji> =
    sequence { yieldAllAvSymbol() }

/**
 * All Emoji of the Symbols: av-symbol subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAvSymbol(): List<Emoji> =
    ArrayList<Emoji>(countAvSymbol).also { list -> sequenceAvSymbol().forEach { list.add(it) } }

@Deprecated("Renamed listAvSymbol.", replaceWith = ReplaceWith("listAvSymbol()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAvSymbol(): List<Emoji> =
    listAvSymbol()
