package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteSmallSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "▫️",
        description = "white small square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-small-square", "white-square-small"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: white small square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteSmallSquare: Emoji get() = _WhiteSmallSquare

/**
 * Alias to emoji [WhiteSmallSquare] (Symbols: geometric: white small square).
*/
public val Emoji.Companion.WhiteSquareSmall: Emoji get() = _WhiteSmallSquare
