package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteSquareButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔳",
        description = "white square button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-square-button", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: white square button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteSquareButton: Emoji get() = _WhiteSquareButton
