package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _YellowCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟡",
        description = "yellow circle",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("yellow-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: yellow circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.YellowCircle: Emoji get() = _YellowCircle
