package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllGeometric() {
    add(intArrayOf(0x1f534), _RedCircle)
    add(intArrayOf(0x1f7e0), _OrangeCircle)
    add(intArrayOf(0x1f7e1), _YellowCircle)
    add(intArrayOf(0x1f7e2), _GreenCircle)
    add(intArrayOf(0x1f535), _BlueCircle)
    add(intArrayOf(0x1f7e3), _PurpleCircle)
    add(intArrayOf(0x1f7e4), _BrownCircle)
    add(intArrayOf(0x26ab), _BlackCircle)
    add(intArrayOf(0x26aa), _WhiteCircle)
    add(intArrayOf(0x1f7e5), _RedSquare)
    add(intArrayOf(0x1f7e7), _OrangeSquare)
    add(intArrayOf(0x1f7e8), _YellowSquare)
    add(intArrayOf(0x1f7e9), _GreenSquare)
    add(intArrayOf(0x1f7e6), _BlueSquare)
    add(intArrayOf(0x1f7ea), _PurpleSquare)
    add(intArrayOf(0x1f7eb), _BrownSquare)
    add(intArrayOf(0x2b1b), _BlackLargeSquare)
    add(intArrayOf(0x2b1c), _WhiteLargeSquare)
    add(intArrayOf(0x25fc, 0xfe0f), _BlackMediumSquare)
    add(intArrayOf(0x25fc), _BlackMediumSquare)
    add(intArrayOf(0x25fb, 0xfe0f), _WhiteMediumSquare)
    add(intArrayOf(0x25fb), _WhiteMediumSquare)
    add(intArrayOf(0x25fe), _BlackMediumSmallSquare)
    add(intArrayOf(0x25fd), _WhiteMediumSmallSquare)
    add(intArrayOf(0x25aa, 0xfe0f), _BlackSmallSquare)
    add(intArrayOf(0x25aa), _BlackSmallSquare)
    add(intArrayOf(0x25ab, 0xfe0f), _WhiteSmallSquare)
    add(intArrayOf(0x25ab), _WhiteSmallSquare)
    add(intArrayOf(0x1f536), _LargeOrangeDiamond)
    add(intArrayOf(0x1f537), _LargeBlueDiamond)
    add(intArrayOf(0x1f538), _SmallOrangeDiamond)
    add(intArrayOf(0x1f539), _SmallBlueDiamond)
    add(intArrayOf(0x1f53a), _RedTrianglePointedUp)
    add(intArrayOf(0x1f53b), _RedTrianglePointedDown)
    add(intArrayOf(0x1f4a0), _DiamondWithADot)
    add(intArrayOf(0x1f518), _RadioButton)
    add(intArrayOf(0x1f533), _WhiteSquareButton)
    add(intArrayOf(0x1f532), _BlackSquareButton)
}

internal suspend fun SequenceScope<Emoji>.yieldAllGeometric() {
    yield(_RedCircle)
    yield(_OrangeCircle)
    yield(_YellowCircle)
    yield(_GreenCircle)
    yield(_BlueCircle)
    yield(_PurpleCircle)
    yield(_BrownCircle)
    yield(_BlackCircle)
    yield(_WhiteCircle)
    yield(_RedSquare)
    yield(_OrangeSquare)
    yield(_YellowSquare)
    yield(_GreenSquare)
    yield(_BlueSquare)
    yield(_PurpleSquare)
    yield(_BrownSquare)
    yield(_BlackLargeSquare)
    yield(_WhiteLargeSquare)
    yield(_BlackMediumSquare)
    yield(_WhiteMediumSquare)
    yield(_BlackMediumSmallSquare)
    yield(_WhiteMediumSmallSquare)
    yield(_BlackSmallSquare)
    yield(_WhiteSmallSquare)
    yield(_LargeOrangeDiamond)
    yield(_LargeBlueDiamond)
    yield(_SmallOrangeDiamond)
    yield(_SmallBlueDiamond)
    yield(_RedTrianglePointedUp)
    yield(_RedTrianglePointedDown)
    yield(_DiamondWithADot)
    yield(_RadioButton)
    yield(_WhiteSquareButton)
    yield(_BlackSquareButton)
}

internal val countGeometric = 34

/**
 * All Emoji of the Symbols: geometric subgroup.
*/
public fun Emoji.Companion.sequenceGeometric(): Sequence<Emoji> =
    sequence { yieldAllGeometric() }

/**
 * All Emoji of the Symbols: geometric subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listGeometric(): List<Emoji> =
    ArrayList<Emoji>(countGeometric).also { list -> sequenceGeometric().forEach { list.add(it) } }

@Deprecated("Renamed listGeometric.", replaceWith = ReplaceWith("listGeometric()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allGeometric(): List<Emoji> =
    listGeometric()
