package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap10: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔟",
        description = "keycap: 10",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-10", "ten", "keycap-ten"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 10.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap10: Emoji get() = _Keycap10

/**
 * Alias to emoji [Keycap10] (Symbols: keycap: keycap: 10).
*/
public val Emoji.Companion.Ten: Emoji get() = _Keycap10

/**
 * Alias to emoji [Keycap10] (Symbols: keycap: keycap: 10).
*/
public val Emoji.Companion.KeycapTen: Emoji get() = _Keycap10
