package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WavyDash: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "〰️",
        description = "wavy dash",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("wavy-dash", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: punctuation: wavy dash.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WavyDash: Emoji get() = _WavyDash
