package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPunctuation() {
    add(intArrayOf(0x203c, 0xfe0f), _DoubleExclamationMark)
    add(intArrayOf(0x203c), _DoubleExclamationMark)
    add(intArrayOf(0x2049, 0xfe0f), _ExclamationQuestionMark)
    add(intArrayOf(0x2049), _ExclamationQuestionMark)
    add(intArrayOf(0x2753), _RedQuestionMark)
    add(intArrayOf(0x2754), _WhiteQuestionMark)
    add(intArrayOf(0x2755), _WhiteExclamationMark)
    add(intArrayOf(0x2757), _RedExclamationMark)
    add(intArrayOf(0x3030, 0xfe0f), _WavyDash)
    add(intArrayOf(0x3030), _WavyDash)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPunctuation() {
    yield(_DoubleExclamationMark)
    yield(_ExclamationQuestionMark)
    yield(_RedQuestionMark)
    yield(_WhiteQuestionMark)
    yield(_WhiteExclamationMark)
    yield(_RedExclamationMark)
    yield(_WavyDash)
}

internal val countPunctuation = 7

/**
 * All Emoji of the Symbols: punctuation subgroup.
*/
public fun Emoji.Companion.sequencePunctuation(): Sequence<Emoji> =
    sequence { yieldAllPunctuation() }

/**
 * All Emoji of the Symbols: punctuation subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPunctuation(): List<Emoji> =
    ArrayList<Emoji>(countPunctuation).also { list -> sequencePunctuation().forEach { list.add(it) } }

@Deprecated("Renamed listPunctuation.", replaceWith = ReplaceWith("listPunctuation()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPunctuation(): List<Emoji> =
    listPunctuation()
