package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NoOneUnderEighteen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔞",
        description = "no one under eighteen",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("no-one-under-eighteen", "no-under-eighteen"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: warning: no one under eighteen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NoOneUnderEighteen: Emoji get() = _NoOneUnderEighteen

/**
 * Alias to emoji [NoOneUnderEighteen] (Symbols: warning: no one under eighteen).
*/
public val Emoji.Companion.NoUnderEighteen: Emoji get() = _NoOneUnderEighteen
