package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceBuilding() {
    add(intArrayOf(0x1f3df, 0xfe0f), _Stadium)
    add(intArrayOf(0x1f3df), _Stadium)
    add(intArrayOf(0x1f3db, 0xfe0f), _ClassicalBuilding)
    add(intArrayOf(0x1f3db), _ClassicalBuilding)
    add(intArrayOf(0x1f3d7, 0xfe0f), _BuildingConstruction)
    add(intArrayOf(0x1f3d7), _BuildingConstruction)
    add(intArrayOf(0x1f9f1), _Brick)
    add(intArrayOf(0x1faa8), _Rock)
    add(intArrayOf(0x1fab5), _Wood)
    add(intArrayOf(0x1f6d6), _Hut)
    add(intArrayOf(0x1f3d8, 0xfe0f), _Houses)
    add(intArrayOf(0x1f3d8), _Houses)
    add(intArrayOf(0x1f3da, 0xfe0f), _DerelictHouse)
    add(intArrayOf(0x1f3da), _DerelictHouse)
    add(intArrayOf(0x1f3e0), _House)
    add(intArrayOf(0x1f3e1), _HouseWithGarden)
    add(intArrayOf(0x1f3e2), _OfficeBuilding)
    add(intArrayOf(0x1f3e3), _JapanesePostOffice)
    add(intArrayOf(0x1f3e4), _PostOffice)
    add(intArrayOf(0x1f3e5), _Hospital)
    add(intArrayOf(0x1f3e6), _Bank)
    add(intArrayOf(0x1f3e8), _Hotel)
    add(intArrayOf(0x1f3e9), _LoveHotel)
    add(intArrayOf(0x1f3ea), _ConvenienceStore)
    add(intArrayOf(0x1f3eb), _School)
    add(intArrayOf(0x1f3ec), _DepartmentStore)
    add(intArrayOf(0x1f3ed), _Factory)
    add(intArrayOf(0x1f3ef), _JapaneseCastle)
    add(intArrayOf(0x1f3f0), _Castle)
    add(intArrayOf(0x1f492), _Wedding)
    add(intArrayOf(0x1f5fc), _TokyoTower)
    add(intArrayOf(0x1f5fd), _StatueOfLiberty)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPlaceBuilding() {
    yield(_Stadium)
    yield(_ClassicalBuilding)
    yield(_BuildingConstruction)
    yield(_Brick)
    yield(_Rock)
    yield(_Wood)
    yield(_Hut)
    yield(_Houses)
    yield(_DerelictHouse)
    yield(_House)
    yield(_HouseWithGarden)
    yield(_OfficeBuilding)
    yield(_JapanesePostOffice)
    yield(_PostOffice)
    yield(_Hospital)
    yield(_Bank)
    yield(_Hotel)
    yield(_LoveHotel)
    yield(_ConvenienceStore)
    yield(_School)
    yield(_DepartmentStore)
    yield(_Factory)
    yield(_JapaneseCastle)
    yield(_Castle)
    yield(_Wedding)
    yield(_TokyoTower)
    yield(_StatueOfLiberty)
}

internal val countPlaceBuilding = 27

/**
 * All Emoji of the Travel & Places: place-building subgroup.
*/
public fun Emoji.Companion.sequencePlaceBuilding(): Sequence<Emoji> =
    sequence { yieldAllPlaceBuilding() }

/**
 * All Emoji of the Travel & Places: place-building subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPlaceBuilding(): List<Emoji> =
    ArrayList<Emoji>(countPlaceBuilding).also { list -> sequencePlaceBuilding().forEach { list.add(it) } }

@Deprecated("Renamed listPlaceBuilding.", replaceWith = ReplaceWith("listPlaceBuilding()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPlaceBuilding(): List<Emoji> =
    listPlaceBuilding()
