package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GlobeWithMeridians: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌐",
        description = "globe with meridians",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("globe-with-meridians", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-map: globe with meridians.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GlobeWithMeridians: Emoji get() = _GlobeWithMeridians
