package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunBehindCloud: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛅",
        description = "sun behind cloud",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sun-behind-cloud", "partly-sunny"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun behind cloud.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunBehindCloud: Emoji get() = _SunBehindCloud

/**
 * Alias to emoji [SunBehindCloud] (Travel & Places: sky & weather: sun behind cloud).
*/
public val Emoji.Companion.PartlySunny: Emoji get() = _SunBehindCloud
