package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WaxingCrescentMoon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌒",
        description = "waxing crescent moon",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("waxing-crescent-moon", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: waxing crescent moon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WaxingCrescentMoon: Emoji get() = _WaxingCrescentMoon
