package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NineOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕘",
        description = "nine o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("nine-oclock", "nine-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: nine o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NineOclock: Emoji get() = _NineOclock

/**
 * Alias to emoji [NineOclock] (Travel & Places: time: nine o’clock).
*/
public val Emoji.Companion.NineOClock: Emoji get() = _NineOclock
