package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OneOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕐",
        description = "one o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("one-oclock", "one-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: one o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OneOclock: Emoji get() = _OneOclock

/**
 * Alias to emoji [OneOclock] (Travel & Places: time: one o’clock).
*/
public val Emoji.Companion.OneOClock: Emoji get() = _OneOclock
