package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportGround() {
    add(intArrayOf(0x1f682), _Locomotive)
    add(intArrayOf(0x1f683), _RailwayCar)
    add(intArrayOf(0x1f684), _HighSpeedTrain)
    add(intArrayOf(0x1f685), _BulletTrain)
    add(intArrayOf(0x1f686), _Train)
    add(intArrayOf(0x1f687), _Metro)
    add(intArrayOf(0x1f688), _LightRail)
    add(intArrayOf(0x1f689), _Station)
    add(intArrayOf(0x1f68a), _Tram)
    add(intArrayOf(0x1f69d), _Monorail)
    add(intArrayOf(0x1f69e), _MountainRailway)
    add(intArrayOf(0x1f68b), _TramCar)
    add(intArrayOf(0x1f68c), _Bus)
    add(intArrayOf(0x1f68d), _OncomingBus)
    add(intArrayOf(0x1f68e), _Trolleybus)
    add(intArrayOf(0x1f690), _Minibus)
    add(intArrayOf(0x1f691), _Ambulance)
    add(intArrayOf(0x1f692), _FireEngine)
    add(intArrayOf(0x1f693), _PoliceCar)
    add(intArrayOf(0x1f694), _OncomingPoliceCar)
    add(intArrayOf(0x1f695), _Taxi)
    add(intArrayOf(0x1f696), _OncomingTaxi)
    add(intArrayOf(0x1f697), _Automobile)
    add(intArrayOf(0x1f698), _OncomingAutomobile)
    add(intArrayOf(0x1f699), _SportUtilityVehicle)
    add(intArrayOf(0x1f6fb), _PickupTruck)
    add(intArrayOf(0x1f69a), _DeliveryTruck)
    add(intArrayOf(0x1f69b), _ArticulatedLorry)
    add(intArrayOf(0x1f69c), _Tractor)
    add(intArrayOf(0x1f3ce, 0xfe0f), _RacingCar)
    add(intArrayOf(0x1f3ce), _RacingCar)
    add(intArrayOf(0x1f3cd, 0xfe0f), _Motorcycle)
    add(intArrayOf(0x1f3cd), _Motorcycle)
    add(intArrayOf(0x1f6f5), _MotorScooter)
    add(intArrayOf(0x1f9bd), _ManualWheelchair)
    add(intArrayOf(0x1f9bc), _MotorizedWheelchair)
    add(intArrayOf(0x1f6fa), _AutoRickshaw)
    add(intArrayOf(0x1f6b2), _Bicycle)
    add(intArrayOf(0x1f6f4), _KickScooter)
    add(intArrayOf(0x1f6f9), _Skateboard)
    add(intArrayOf(0x1f6fc), _RollerSkate)
    add(intArrayOf(0x1f68f), _BusStop)
    add(intArrayOf(0x1f6e3, 0xfe0f), _Motorway)
    add(intArrayOf(0x1f6e3), _Motorway)
    add(intArrayOf(0x1f6e4, 0xfe0f), _RailwayTrack)
    add(intArrayOf(0x1f6e4), _RailwayTrack)
    add(intArrayOf(0x1f6e2, 0xfe0f), _OilDrum)
    add(intArrayOf(0x1f6e2), _OilDrum)
    add(intArrayOf(0x26fd), _FuelPump)
    add(intArrayOf(0x1f6de), _Wheel)
    add(intArrayOf(0x1f6a8), _PoliceCarLight)
    add(intArrayOf(0x1f6a5), _HorizontalTrafficLight)
    add(intArrayOf(0x1f6a6), _VerticalTrafficLight)
    add(intArrayOf(0x1f6d1), _StopSign)
    add(intArrayOf(0x1f6a7), _Construction)
}

internal suspend fun SequenceScope<Emoji>.yieldAllTransportGround() {
    yield(_Locomotive)
    yield(_RailwayCar)
    yield(_HighSpeedTrain)
    yield(_BulletTrain)
    yield(_Train)
    yield(_Metro)
    yield(_LightRail)
    yield(_Station)
    yield(_Tram)
    yield(_Monorail)
    yield(_MountainRailway)
    yield(_TramCar)
    yield(_Bus)
    yield(_OncomingBus)
    yield(_Trolleybus)
    yield(_Minibus)
    yield(_Ambulance)
    yield(_FireEngine)
    yield(_PoliceCar)
    yield(_OncomingPoliceCar)
    yield(_Taxi)
    yield(_OncomingTaxi)
    yield(_Automobile)
    yield(_OncomingAutomobile)
    yield(_SportUtilityVehicle)
    yield(_PickupTruck)
    yield(_DeliveryTruck)
    yield(_ArticulatedLorry)
    yield(_Tractor)
    yield(_RacingCar)
    yield(_Motorcycle)
    yield(_MotorScooter)
    yield(_ManualWheelchair)
    yield(_MotorizedWheelchair)
    yield(_AutoRickshaw)
    yield(_Bicycle)
    yield(_KickScooter)
    yield(_Skateboard)
    yield(_RollerSkate)
    yield(_BusStop)
    yield(_Motorway)
    yield(_RailwayTrack)
    yield(_OilDrum)
    yield(_FuelPump)
    yield(_Wheel)
    yield(_PoliceCarLight)
    yield(_HorizontalTrafficLight)
    yield(_VerticalTrafficLight)
    yield(_StopSign)
    yield(_Construction)
}

internal val countTransportGround = 50

/**
 * All Emoji of the Travel & Places: transport-ground subgroup.
*/
public fun Emoji.Companion.sequenceTransportGround(): Sequence<Emoji> =
    sequence { yieldAllTransportGround() }

/**
 * All Emoji of the Travel & Places: transport-ground subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listTransportGround(): List<Emoji> =
    ArrayList<Emoji>(countTransportGround).also { list -> sequenceTransportGround().forEach { list.add(it) } }

@Deprecated("Renamed listTransportGround.", replaceWith = ReplaceWith("listTransportGround()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allTransportGround(): List<Emoji> =
    listTransportGround()
