package org.kodein.emoji.travel_places.transport_water

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportWater() {
    add(intArrayOf(0x2693), _Anchor)
    add(intArrayOf(0x1f6df), _RingBuoy)
    add(intArrayOf(0x26f5), _Sailboat)
    add(intArrayOf(0x1f6f6), _Canoe)
    add(intArrayOf(0x1f6a4), _Speedboat)
    add(intArrayOf(0x1f6f3, 0xfe0f), _PassengerShip)
    add(intArrayOf(0x1f6f3), _PassengerShip)
    add(intArrayOf(0x26f4, 0xfe0f), _Ferry)
    add(intArrayOf(0x26f4), _Ferry)
    add(intArrayOf(0x1f6e5, 0xfe0f), _MotorBoat)
    add(intArrayOf(0x1f6e5), _MotorBoat)
    add(intArrayOf(0x1f6a2), _Ship)
}

internal suspend fun SequenceScope<Emoji>.yieldAllTransportWater() {
    yield(_Anchor)
    yield(_RingBuoy)
    yield(_Sailboat)
    yield(_Canoe)
    yield(_Speedboat)
    yield(_PassengerShip)
    yield(_Ferry)
    yield(_MotorBoat)
    yield(_Ship)
}

internal val countTransportWater = 9

/**
 * All Emoji of the Travel & Places: transport-water subgroup.
*/
public fun Emoji.Companion.sequenceTransportWater(): Sequence<Emoji> =
    sequence { yieldAllTransportWater() }

/**
 * All Emoji of the Travel & Places: transport-water subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listTransportWater(): List<Emoji> =
    ArrayList<Emoji>(countTransportWater).also { list -> sequenceTransportWater().forEach { list.add(it) } }

@Deprecated("Renamed listTransportWater.", replaceWith = ReplaceWith("listTransportWater()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allTransportWater(): List<Emoji> =
    listTransportWater()
