package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCzechia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇿",
        description = "flag: Czechia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-czechia", "czechia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Czechia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCzechia: Emoji get() = _FlagCzechia

/**
 * Alias to emoji [FlagCzechia] (Flags: country-flag: flag: Czechia).
*/
public val Emoji.Companion.CzechiaFlag: Emoji get() = _FlagCzechia
