package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagDominicanRepublic: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇴",
        description = "flag: Dominican Republic",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-dominican-republic", "dominican-republic-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Dominican Republic.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagDominicanRepublic: Emoji get() = _FlagDominicanRepublic

/**
 * Alias to emoji [FlagDominicanRepublic] (Flags: country-flag: flag: Dominican Republic).
*/
public val Emoji.Companion.DominicanRepublicFlag: Emoji get() = _FlagDominicanRepublic
