package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuinea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇳",
        description = "flag: Guinea",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guinea", "guinea-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guinea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuinea: Emoji get() = _FlagGuinea

/**
 * Alias to emoji [FlagGuinea] (Flags: country-flag: flag: Guinea).
*/
public val Emoji.Companion.GuineaFlag: Emoji get() = _FlagGuinea
