package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNicaragua: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇮",
        description = "flag: Nicaragua",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-nicaragua", "nicaragua-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Nicaragua.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNicaragua: Emoji get() = _FlagNicaragua

/**
 * Alias to emoji [FlagNicaragua] (Flags: country-flag: flag: Nicaragua).
*/
public val Emoji.Companion.NicaraguaFlag: Emoji get() = _FlagNicaragua
