package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagRwanda: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇷🇼",
        description = "flag: Rwanda",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-rwanda", "rwanda-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Rwanda.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagRwanda: Emoji get() = _FlagRwanda

/**
 * Alias to emoji [FlagRwanda] (Flags: country-flag: flag: Rwanda).
*/
public val Emoji.Companion.RwandaFlag: Emoji get() = _FlagRwanda
