package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStMartin: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇫",
        description = "flag: St. Martin",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-martin", "st-martin-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Martin.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStMartin: Emoji get() = _FlagStMartin

/**
 * Alias to emoji [FlagStMartin] (Flags: country-flag: flag: St. Martin).
*/
public val Emoji.Companion.StMartinFlag: Emoji get() = _FlagStMartin
