package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagZambia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇿🇲",
        description = "flag: Zambia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-zambia", "zambia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Zambia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagZambia: Emoji get() = _FlagZambia

/**
 * Alias to emoji [FlagZambia] (Flags: country-flag: flag: Zambia).
*/
public val Emoji.Companion.ZambiaFlag: Emoji get() = _FlagZambia
