package org.kodein.emoji.flags.subdivision_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllSubdivisionFlag() {
    add(intArrayOf(0x1f3f4, 0xe0067, 0xe0062, 0xe0065, 0xe006e, 0xe0067, 0xe007f), _FlagEngland)
    add(intArrayOf(0x1f3f4, 0xe0067, 0xe0062, 0xe0073, 0xe0063, 0xe0074, 0xe007f), _FlagScotland)
    add(intArrayOf(0x1f3f4, 0xe0067, 0xe0062, 0xe0077, 0xe006c, 0xe0073, 0xe007f), _FlagWales)
}

internal suspend fun SequenceScope<Emoji>.yieldAllSubdivisionFlag() {
    yield(_FlagEngland)
    yield(_FlagScotland)
    yield(_FlagWales)
}

internal val countSubdivisionFlag = 3

/**
 * All Emoji of the Flags: subdivision-flag subgroup.
*/
public fun Emoji.Companion.sequenceSubdivisionFlag(): Sequence<Emoji> =
    sequence { yieldAllSubdivisionFlag() }

/**
 * All Emoji of the Flags: subdivision-flag subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listSubdivisionFlag(): List<Emoji> =
    ArrayList<Emoji>(countSubdivisionFlag).also { list -> sequenceSubdivisionFlag().forEach { list.add(it) } }

@Deprecated("Renamed listSubdivisionFlag.", replaceWith = ReplaceWith("listSubdivisionFlag()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allSubdivisionFlag(): List<Emoji> =
    listSubdivisionFlag()
