package org.kodein.emoji.food_drink.food_asian

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodAsian() {
    add(intArrayOf(0x1f371), _BentoBox)
    add(intArrayOf(0x1f358), _RiceCracker)
    add(intArrayOf(0x1f359), _RiceBall)
    add(intArrayOf(0x1f35a), _CookedRice)
    add(intArrayOf(0x1f35b), _CurryRice)
    add(intArrayOf(0x1f35c), _SteamingBowl)
    add(intArrayOf(0x1f35d), _Spaghetti)
    add(intArrayOf(0x1f360), _RoastedSweetPotato)
    add(intArrayOf(0x1f362), _Oden)
    add(intArrayOf(0x1f363), _Sushi)
    add(intArrayOf(0x1f364), _FriedShrimp)
    add(intArrayOf(0x1f365), _FishCakeWithSwirl)
    add(intArrayOf(0x1f96e), _MoonCake)
    add(intArrayOf(0x1f361), _Dango)
    add(intArrayOf(0x1f95f), _Dumpling)
    add(intArrayOf(0x1f960), _FortuneCookie)
    add(intArrayOf(0x1f961), _TakeoutBox)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodAsian() {
    yield(_BentoBox)
    yield(_RiceCracker)
    yield(_RiceBall)
    yield(_CookedRice)
    yield(_CurryRice)
    yield(_SteamingBowl)
    yield(_Spaghetti)
    yield(_RoastedSweetPotato)
    yield(_Oden)
    yield(_Sushi)
    yield(_FriedShrimp)
    yield(_FishCakeWithSwirl)
    yield(_MoonCake)
    yield(_Dango)
    yield(_Dumpling)
    yield(_FortuneCookie)
    yield(_TakeoutBox)
}

internal val countFoodAsian = 17

/**
 * All Emoji of the Food & Drink: food-asian subgroup.
*/
public fun Emoji.Companion.sequenceFoodAsian(): Sequence<Emoji> =
    sequence { yieldAllFoodAsian() }

/**
 * All Emoji of the Food & Drink: food-asian subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFoodAsian(): List<Emoji> =
    ArrayList<Emoji>(countFoodAsian).also { list -> sequenceFoodAsian().forEach { list.add(it) } }

@Deprecated("Renamed listFoodAsian.", replaceWith = ReplaceWith("listFoodAsian()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFoodAsian(): List<Emoji> =
    listFoodAsian()
