package org.kodein.emoji.food_drink.food_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodMarine() {
    add(intArrayOf(0x1f980), _Crab)
    add(intArrayOf(0x1f99e), _Lobster)
    add(intArrayOf(0x1f990), _Shrimp)
    add(intArrayOf(0x1f991), _Squid)
    add(intArrayOf(0x1f9aa), _Oyster)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodMarine() {
    yield(_Crab)
    yield(_Lobster)
    yield(_Shrimp)
    yield(_Squid)
    yield(_Oyster)
}

internal val countFoodMarine = 5

/**
 * All Emoji of the Food & Drink: food-marine subgroup.
*/
public fun Emoji.Companion.sequenceFoodMarine(): Sequence<Emoji> =
    sequence { yieldAllFoodMarine() }

/**
 * All Emoji of the Food & Drink: food-marine subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFoodMarine(): List<Emoji> =
    ArrayList<Emoji>(countFoodMarine).also { list -> sequenceFoodMarine().forEach { list.add(it) } }

@Deprecated("Renamed listFoodMarine.", replaceWith = ReplaceWith("listFoodMarine()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFoodMarine(): List<Emoji> =
    listFoodMarine()
