package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShoppingCart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛒",
        description = "shopping cart",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("shopping-cart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: household: shopping cart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShoppingCart: Emoji get() = _ShoppingCart
