package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Placard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪧",
        description = "placard",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("placard", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: other-object: placard.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Placard: Emoji get() = _Placard
