package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPhone() {
    add(intArrayOf(0x1f4f1), _MobilePhone)
    add(intArrayOf(0x1f4f2), _MobilePhoneWithArrow)
    add(intArrayOf(0x260e, 0xfe0f), _Telephone)
    add(intArrayOf(0x260e), _Telephone)
    add(intArrayOf(0x1f4de), _TelephoneReceiver)
    add(intArrayOf(0x1f4df), _Pager)
    add(intArrayOf(0x1f4e0), _FaxMachine)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPhone() {
    yield(_MobilePhone)
    yield(_MobilePhoneWithArrow)
    yield(_Telephone)
    yield(_TelephoneReceiver)
    yield(_Pager)
    yield(_FaxMachine)
}

internal val countPhone = 6

/**
 * All Emoji of the Objects: phone subgroup.
*/
public fun Emoji.Companion.sequencePhone(): Sequence<Emoji> =
    sequence { yieldAllPhone() }

/**
 * All Emoji of the Objects: phone subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPhone(): List<Emoji> =
    ArrayList<Emoji>(countPhone).also { list -> sequencePhone().forEach { list.add(it) } }

@Deprecated("Renamed listPhone.", replaceWith = ReplaceWith("listPhone()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPhone(): List<Emoji> =
    listPhone()
